# 如何进行二次开发
##背景
UEditor虽然功能众多，但对于广大开发者来说，还是有很多定制化的功能需求，如果都靠UEditor团队自己开发那是不现实的，这时就需要广大开发者在UEditor的基础上自己开发定制功能。但在之前的版本中，UEditor对于二次开发的支持不够优化，经常需要开发者不仅要开发相应的功能，例如command命令,plugin插件等，还要在UEditor上修改多处文件，例如，添加按钮，添加样式等等，才能将功能添加到UEditor中。这样的方式对于以后的升级和后续定制功能的维护，都会造成维护困难的问题。介于次，UEditor从1.4.1开始，添加对于二次开发的扩展支持。

##二次开发方式
无需对UEditor代码做任何修改，只需在UEditor之外通过UEditor提供的二次开发接口开发定制功能.这种开发方式不仅避免了修改UEditor源码，方便日后UEditor的升级，而且通过接口，可以将开发的定制功能维护到一个文件中或者一个目录中，方便日后对其维护。


##部署定制功能
对于UEditor的二次开发，一般多为添加按钮，下拉筐或者是添加一个dialog。基于这几种常规的方式，我在_examples目录下分别书写了3个类型的定制demo。

1. addCustomizeButton.js 添加一个按钮
2. addCustomizeCombox.js 添加一个下拉框
3. addCustomizeDialog.js 添加一个弹出层

除了添加弹出层需要一个而外的html页面外，对于需要添加和修改的功能代码全部都维护到一个js文件中了。

使用文件的方式:
```html
    <script type="text/javascript" charset="utf-8" src="../ueditor.config.js"></script>
    <script type="text/javascript" charset="utf-8" src="editor_api.js"> </script>
    <script type="text/javascript" charset="utf-8" src="../lang/zh-cn/zh-cn.js"></script>
    <!--添加按钮-->
    <script type="text/javascript" charset="utf-8" src="addCustomizeButton.js"></script>
```

新添加的按钮就完成了。实例化编辑器时，无需再而外添加任何代码。

##开发细节
前面讲了如何部署你的功能，这个小节来和大家讲一下，UEditor提供那些接口，让大家可以在编辑器之外扩展你的功能。

```javascript
UE.registerUI('uiname',function(editor,uiname){
    //do something
},[index,[editorId]]);
```

考虑到大家的功能基本上都会扩展一个UI和这个UI做的事情，所以UEditor提供了registerUI这个接口，可以让开发者动态的注入扩展的内容。

1. **uiname**,是你为新添加的UI起的名字，这里可以是1个或者多个，“uiname”后者是“uiname1 uiname2 uiname3”
2. **function**，是实际你要做的事情，这里提供两个参数，**editor**是编辑器实例，如果你有多个编辑器实例，那每个编辑器实例化后，都会调用这个function,并且把editor传进来,**uiname**,你为ui起的名字，如果前边你添加的是多个的化，这里function会被调用多次，并且将每一个ui名字传递进来.如果函数返回了一个UI 实例，那这个UI实例就会被默认加到工具栏上。当然也可以不返回任何UI。比如希望监控selectionchange事件，在某些场景下弹出浮层，这时就不需要返回任何UI.
3. **index**,是你想放到toolbar的那个位置，默认是放到最后
4. **editorId**,当你的页面上有多个编辑器实例时，你想将这个ui扩展到那个编辑器实例上，这里的editorId是给你编辑器初始化时，传入的id,默认是每个实例都会加入你的扩展

###添加按钮
添加一个按钮

```javascript
UE.registerUI('button',function(editor,uiName){
    //注册按钮执行时的command命令，使用命令默认就会带有回退操作
    editor.registerCommand(uiName,{
        execCommand:function(){
            alert('execCommand:' + uiName)
        }
    });
    //创建一个button
    var btn = new UE.ui.Button({
        //按钮的名字
        name:uiName,
        //提示
        title:uiName,
        //添加额外样式，指定icon图标，这里默认使用一个重复的icon
        cssRules :'background-position: -500px 0;',
        //点击时执行的命令
        onclick:function () {
            //这里可以不用执行命令,做你自己的操作也可
            editor.execCommand(uiName);
        }
    });
    //当点到编辑内容上时，按钮要做的状态反射
    editor.addListener('selectionchange', function () {
        var state = editor.queryCommandState(uiName);
        if (state == -1) {
            btn.setDisabled(true);
            btn.setChecked(false);
        } else {
            btn.setDisabled(false);
            btn.setChecked(state);
        }
    });
    //因为你是添加button,所以需要返回这个button
    return btn;
});
```

添加多个
```javascript
UE.registerUI('bold italic redo undo underline strikethrough',function(editor,uiName){
    //注册按钮执行时的command命令，使用命令默认就会带有回退操作
    editor.registerCommand(uiName,{
        execCommand:function(){
            alert('execCommand:' + uiName)
        }
    });
    //创建一个button
    var btn = new UE.ui.Button({
        //按钮的名字
        name:uiName,
        //提示
        title:uiName,
        //添加额外样式,指定icon图标,这里默认使用一个重复的icon
        cssRules :'background-position: -500px 0;',
        //点击时执行的命令
        onclick:function () {
            //这里可以不用执行命令,做你自己的操作也可
            editor.execCommand(uiName);
        }
    });
    //当点到编辑内容上时，按钮要做的状态反射
    editor.addListener('selectionchange', function () {
        var state = editor.queryCommandState(uiName);
        if (state == -1) {
            btn.setDisabled(true);
            btn.setChecked(false);
        } else {
            btn.setDisabled(false);
            btn.setChecked(state);
        }
    });
    //因为你是添加button,所以需要返回这个button
    return btn;
});
```

在完整版本的下载包里，我写了3个例子，添加一个按钮，下拉筐，弹出一个浮层，大家可以参考

##总结
之前UEditor对于第三方的开发确实支持的不够灵活，导致为了开发还要污染UEditor本身，这为后学升级添加了麻烦。当然现在这个设计可能还有考虑不到的地方，大家可以直接发issue给我们，我们会进行及时的补丁，并在后续的版本中更新。

##谢谢
